from torch_geometric.datasets import Planetoid
from torch_geometric.data import DataLoader, Data
from torch_geometric.utils import accuracy, train_test_split_edges, negative_sampling

import torch
import torch.nn.functional as F
from torch.nn import Linear
from torch_geometric.nn import GCNConv

device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

class Net(torch.nn.Module):
    def __init__(self):
        super(Net, self).__init__()
        self.conv1 = GCNConv(dataset.num_node_features, 16)
        self.linear1 = Linear(32, 1)

    def forward(self, x, edge_index, node_pair ):
        x = self.conv1(x, edge_index)
        x = F.relu(x)
        x = F.dropout(x, training=self.training)

        x = torch.cat( [x[node_pair[0]],x[node_pair[1]]], dim=1 )

        x = self.linear1(x)
        x = x.squeeze(1)

        return x

dataset = Planetoid(root='.', name='Cora')
data = dataset[0]
print('num_nodes',data.num_nodes)
print('edge_index',data.edge_index.shape)

train_test_split_edges( data )

n_pos = data.train_pos_edge_index.shape[1]
data.train_neg_edge_index = negative_sampling( data.train_pos_edge_index, num_neg_samples = n_pos )
n_neg = data.train_neg_edge_index.shape[1]

x = data.x
edge_index = data.train_pos_edge_index
node_pair = torch.cat( [ data.train_pos_edge_index, data.train_neg_edge_index ], dim=1 )
y = torch.cat( [ torch.ones(n_pos), torch.zeros(n_neg) ] )

model = Net()
optimizer = torch.optim.Adam(model.parameters(), lr=0.01, weight_decay=5e-4)

model.train()
for epoch in range(1):
    optimizer.zero_grad()
    out = model(x, edge_index, node_pair)
    loss = F.binary_cross_entropy_with_logits(out, y)
    loss.backward()
    optimizer.step()
