from torch_geometric.datasets import TUDataset
from torch_geometric.data import DataLoader

import torch
import torch.nn.functional as F
from torch.nn import Linear
from torch_geometric.nn import GCNConv, global_mean_pool

device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

class Net(torch.nn.Module):
    def __init__(self):
        super(Net, self).__init__()
        self.conv = GCNConv(dataset.num_node_features, 32)
        self.linear = Linear(32, dataset.num_classes)

    def forward(self, data):
        x, edge_index, batch = data.x, data.edge_index, data.batch

        x = self.conv(x, edge_index)
        x = F.relu(x)
        x = F.dropout(x, training=self.training)

        x = global_mean_pool(x, batch)

        x = self.linear(x)

        return F.log_softmax(x, dim=1)

dataset = TUDataset(root='.', name='PROTEINS')
dataset = dataset.shuffle()
train_data = dataset[:800]
test_data = dataset[800:]

model = Net().to(device)

optimizer = torch.optim.Adam(model.parameters(), lr=0.01, weight_decay=5e-4)

model.train()
for epoch in range(100):
    loader = DataLoader(train_data, batch_size=32, shuffle=True)
    for batch in loader:
        print(batch)
        sys.exit()
        optimizer.zero_grad()
        batch = batch.to(device)
        out = model(batch)
        loss = F.nll_loss(out, batch.y)
        loss.backward()
        optimizer.step() 
