from torch_geometric.datasets import Planetoid
from torch_geometric.data import DataLoader
from torch_geometric.utils import accuracy

import torch
import torch.nn.functional as F
from torch.nn import Linear
from torch_geometric.nn import GCNConv


device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

class Net(torch.nn.Module):
    def __init__(self):
        super(Net, self).__init__()
        self.conv1 = GCNConv(dataset.num_node_features, 32)
        self.conv2 = GCNConv(32, dataset.num_classes)
#        self.linear = Linear(32, dataset.num_classes)

    def forward(self, data):
        x, edge_index = data.x, data.edge_index

        x = self.conv1(x, edge_index)
        x = F.relu(x)
        x = F.dropout(x, training=self.training)

        x = self.conv2(x, edge_index)
#        x = self.linear(x)

        return F.log_softmax(x, dim=1)

dataset = Planetoid(root='.', name='Cora')
data = dataset[0].to(device)

model = Net().to(device)

optimizer = torch.optim.Adam(model.parameters(), lr=0.01, weight_decay=5e-4)

def evaluate(mask):
    model.eval()
    with torch.no_grad():
        _, pred = model(data).max(dim=1)
        acc = accuracy( pred[mask], data.y[mask] )
    #correct = int(pred[mask].eq(data.y[mask]).sum().item())
    #acc = correct / int(mask.sum())
    model.train()
    return acc

print( 'train accuracy:', evaluate(data.train_mask) )
print( 'test  accuracy:', evaluate(data.test_mask ) )

model.train()
for epoch in range(100):
    optimizer.zero_grad()
    out = model(data)
    loss = F.nll_loss(out[data.train_mask], data.y[data.train_mask])
    loss.backward()
    optimizer.step() 

print( 'train accuracy:', evaluate(data.train_mask) )
print( 'test  accuracy:', evaluate(data.test_mask ) )


"""
train accuracy: 0.15
test  accuracy: 0.14
train accuracy: 1.0
test  accuracy: 0.804
"""
