import numpy as np

import torch
from torch_geometric.data import Data
from torch_geometric.utils import is_undirected, contains_self_loops, to_undirected, grid

# Example:
#    v0
#   /
# v1 --- v2
print('Example1 : creating a graph')
edge_index = torch.tensor([[0, 1, 1, 2],
                           [1, 0, 2, 1]], dtype=torch.long)
print(is_undirected( edge_index ))
print(contains_self_loops( edge_index ))
"""
True
False
"""

# Using utils.to_undirected()
print('Example2 : utils.to_undirected()')
edge_index = torch.tensor([[0, 2],
                           [1, 1]], dtype=torch.long)
print(is_undirected( edge_index ))
edge_index = to_undirected( edge_index )
print(is_undirected( edge_index ))
print(contains_self_loops( edge_index ))
"""
False
True
False
"""

# Make grid (8-connected + self-loop)
print('Example3 : torch_geometric.utils.grid()')
edge_index, vpos = grid( 3, 2, dtype=torch.long )
print(edge_index)
print(vpos)
print(is_undirected( edge_index ))
print(contains_self_loops( edge_index ))
"""
tensor([[0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4,
         5, 5, 5, 5],
        [0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 2, 3, 4, 5,
         2, 3, 4, 5]])
tensor([[0, 2],
        [1, 2],
        [0, 1],
        [1, 1],
        [0, 0],
        [1, 0]])
True
True
"""
